\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{mynotes}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}

\RequirePackage{amsmath}
\RequirePackage{amsfonts}
\RequirePackage{amsthm}
\RequirePackage{amssymb}

%\RequirePackage{verbatim}
\RequirePackage{xspace}
%\RequirePackage{multicol}
%\RequirePackage{color}
%\RequirePackage{fancyheadings}
\RequirePackage{graphicx}
%\RequirePackage{makeidx}
%\RequirePackage{hyperref}
%\hypersetup{backref,colorlinks=true,linkcolor=blue,urlcolor=blue,citecolor=red}

%\RequirePackage{listings}
%\RequirePackage{keyval}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  2. Limits, Sums, Integrals, Derivatives, and Fractions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\limn}{\lim_{n\to\infty}}
\newcommand{\dlimn}{\displaystyle\limn}
\newcommand{\dlim}{\displaystyle\lim}
\newcommand{\dprod}{\displaystyle\prod}
\newcommand{\dsum}{\displaystyle\sum}
\newcommand{\dint}{\displaystyle\int}
\newcommand{\Int}{\int_{-\infty}^{\infty}}
\newcommand{\dInt}{\displaystyle\int_{-\infty}^{\infty}}
\providecommand{\dfrac}[2]{\displaystyle\frac{#1}{#2}}
\newcommand{\fracw}[2]{\pbraces{\frac{#1}{#2}}}
\newcommand{\dfracw}[2]{\displaystyle\fracw{#1}{#2}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  3. Matrices and matrix operators
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\bmat}[1]{\begin{bmatrix} #1 \end{bmatrix}}
\newcommand{\pmat}[1]{\begin{pmatrix} #1 \end{pmatrix}}
\newcommand{\diag}{\operatorname{diag}}
\newcommand{\tr}{\operatorname{tr}}
\newcommand{\kron}{{\otimes}}
\newcommand{\rank}{\operatorname{rank}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Delimiters:  (), [], {}, ||, <>, etc.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\braces}[1]{{\left\{#1\right\}}}
  \newcommand{\bigbr}[1]{\bigl\{ #1 \bigr\}}
  \newcommand{\biggbr}[1]{\biggl\{ #1 \biggr\}}
  \newcommand{\Bigbr}[1]{\Bigl\{ #1 \Bigr\}}
  \newcommand{\Biggbr}[1]{\Biggl\{ #1 \Biggr\}}
\newcommand{\bbraces}[1]{{\left[#1\right]}}
  \newcommand{\bigb}[1]{\bigl[ #1 \bigr]}
  \newcommand{\biggb}[1]{\biggl[ #1 \biggr]}
  \newcommand{\Bigb}[1]{\Bigl[ #1 \Bigr]}
  \newcommand{\Biggb}[1]{\Biggl[ #1 \Biggr]}
\newcommand{\pbraces}[1]{{\left(#1\right)}}
  \newcommand{\bigp}[1]{\bigl( #1 \bigr)}
  \newcommand{\biggp}[1]{\biggl( #1 \biggr)}
  \newcommand{\Bigp}[1]{\Bigl( #1 \Bigr)}
  \newcommand{\Biggp}[1]{\Biggl( #1 \Biggr)}
\newcommand{\abs}[1]{{\left|#1\right|}}
\newcommand{\norm}[1]{{\left\|#1\right\|}}
\renewcommand{\angle}[1]{{\langle{#1}\,\rangle}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Means, etc.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
\newcommand{\Xbar}{\bar{X}}
\newcommand{\xbar}{\bar{x}}
\newcommand{\Ybar}{\bar{Y}}
\newcommand{\ybar}{\bar{y}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Operator Names
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\Cov}{\operatorname{Cov}}
\newcommand{\cov}{\operatorname{cov}}
\newcommand{\Corr}{\operatorname{Corr}}
\newcommand{\corr}{\operatorname{corr}}
\newcommand{\Var}{\operatorname{Var}}
\newcommand{\var}{\operatorname{var}}
\newcommand{\Bias}{\operatorname{Bias}}
\newcommand{\bias}{\operatorname{bias}}
\newcommand{\MSE}{\operatorname{MSE}}
\newcommand{\mse}{\operatorname{mse}}
\newcommand{\Med}{\operatorname{med}}
\newcommand{\med}{\operatorname{med}}
\newcommand{\se}{\operatorname{se}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Distributions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\N}{\operatorname{N}} % Normal distribution
\newcommand{\F}{\operatorname{F}} % F distribution
\newcommand{\U}{\operatorname{U}} % Uniform distribution
\newcommand{\Exp}{\operatorname{Exp}}
\newcommand{\Poisson}{\operatorname{Poisson}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Environments
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{closeenum}
{\begin{enumerate}
  \setlength{\topsep}{0pt}
  \setlength{\itemsep}{-2pt}
  \setlength{\parsep}{0pt}
  \setlength{\partopsep}{0pt}
}{\end{enumerate}}

\newenvironment{closeitem}
{\begin{itemize}
  \setlength{\topsep}{0pt}
  \setlength{\itemsep}{-2pt}
  \setlength{\parsep}{0pt}
  \setlength{\partopsep}{0pt}
}{\end{itemize}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Misc Bold Symbols
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\bzero}{\boldsymbol{0}}
\newcommand{\bone} {\boldsymbol{1}}
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Bold Greek Letters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\bmu}{\boldsymbol{\mu}}
\newcommand{\bnu}{\boldsymbol{\nu}}
\newcommand{\bxi}{\boldsymbol{\xi}}
\newcommand{\bpi}{\boldsymbol{\pi}}
\newcommand{\bchi}{\boldsymbol{\chi}}
\newcommand{\bphi}{\boldsymbol{\phi}}
\newcommand{\bpsi}{\boldsymbol{\psi}}
\newcommand{\brho}{\boldsymbol{\rho}}
\newcommand{\btau}{\boldsymbol{\tau}}
\newcommand{\bbeta}{\boldsymbol{\beta}}
\newcommand{\bfeta}{\boldsymbol{\eta}}
\newcommand{\biota}{\boldsymbol{\iota}}
\newcommand{\bzeta}{\boldsymbol{\zeta}}
\newcommand{\balpha}{\boldsymbol{\alpha}}
\newcommand{\bdelta}{\boldsymbol{\delta}}
\newcommand{\bgamma}{\boldsymbol{\gamma}}
\newcommand{\bkappa}{\boldsymbol{\kappa}}
\newcommand{\bomega}{\boldsymbol{\omega}}
\newcommand{\bsigma}{\boldsymbol{\sigma}}
\newcommand{\btheta}{\boldsymbol{\theta}}
\newcommand{\blambda}{\boldsymbol{\lambda}}
\newcommand{\bvarphi}{\boldsymbol{\varphi}}
\newcommand{\bupsilon}{\boldsymbol{\upsilon}}
\newcommand{\bepsilon}{\boldsymbol{\epsilon}}
\newcommand{\bvarepsilon}{\boldsymbol{\varepsilon}}

\newcommand{\bXi}{\boldsymbol{\Xi}}
\newcommand{\bPi}{\boldsymbol{\Pi}}
\newcommand{\bPhi}{\boldsymbol{\Phi}}
\newcommand{\bPsi}{\boldsymbol{\Psi}}
\newcommand{\bGamma}{\boldsymbol{\Gamma}}
\newcommand{\bDelta}{\boldsymbol{\Delta}}
\newcommand{\bTheta}{\boldsymbol{\Theta}}
\newcommand{\bSigma}{\boldsymbol{\Sigma}}
\newcommand{\bOmega}{\boldsymbol{\Omega}}
\newcommand{\bLambda}{\boldsymbol{\Lambda}}
\newcommand{\bUpsilon}{\boldsymbol{\Upsilon}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Bold Letters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\bA}{\mathbf{A}} \newcommand{\ba}{\mathbf{a}}
\newcommand{\bB}{\mathbf{B}} \newcommand{\bb}{\mathbf{b}}
\newcommand{\bC}{\mathbf{C}} \newcommand{\bc}{\mathbf{c}}
\newcommand{\bD}{\mathbf{D}} \newcommand{\bd}{\mathbf{d}}
\newcommand{\bE}{\mathbf{E}} \newcommand{\be}{\mathbf{e}}
\newcommand{\bF}{\mathbf{F}} \newcommand{\bff}{\mathbf{f}}
\newcommand{\bG}{\mathbf{G}} \newcommand{\bg}{\mathbf{g}}
\newcommand{\bH}{\mathbf{H}} \newcommand{\bh}{\mathbf{h}}
\newcommand{\bI}{\mathbf{I}} \newcommand{\bi}{\mathbf{i}}
\newcommand{\bJ}{\mathbf{J}} \newcommand{\bj}{\mathbf{j}}
\newcommand{\bK}{\mathbf{K}} \newcommand{\bk}{\mathbf{k}}
\newcommand{\bL}{\mathbf{L}} \newcommand{\bl}{\mathbf{l}}
\newcommand{\bM}{\mathbf{M}} \newcommand{\bm}{\mathbf{m}} 
\newcommand{\bN}{\mathbf{N}} \newcommand{\bn}{\mathbf{n}} 
\newcommand{\bO}{\mathbf{O}} \newcommand{\bo}{\mathbf{o}}
\newcommand{\bP}{\mathbf{P}} \newcommand{\bp}{\mathbf{p}}
\newcommand{\bQ}{\mathbf{Q}} \newcommand{\bq}{\mathbf{q}}
\newcommand{\bR}{\mathbf{R}} \newcommand{\br}{\mathbf{r}}
\newcommand{\bS}{\mathbf{S}} \newcommand{\bs}{\mathbf{s}}
\newcommand{\bT}{\mathbf{T}} \newcommand{\bt}{\mathbf{t}}
\newcommand{\bU}{\mathbf{U}} \newcommand{\bu}{\mathbf{u}}
\newcommand{\bV}{\mathbf{V}} \newcommand{\bv}{\mathbf{v}}
\newcommand{\bW}{\mathbf{W}} \newcommand{\bw}{\mathbf{w}}
\newcommand{\bX}{\mathbf{X}} \newcommand{\bx}{\mathbf{x}}
\newcommand{\bY}{\mathbf{Y}} \newcommand{\by}{\mathbf{y}}
\newcommand{\bZ}{\mathbf{Z}} \newcommand{\bz}{\mathbf{z}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Calligraphic Letters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\cA}{\cal{A}} \newcommand{\cB}{\cal{B}}
\newcommand{\cC}{\cal{C}} \newcommand{\cD}{\cal{D}}
\newcommand{\cE}{\cal{E}} \newcommand{\cF}{\cal{F}}
\newcommand{\cG}{\cal{G}} \newcommand{\cH}{\cal{H}}
\newcommand{\cI}{\cal{I}} \newcommand{\cJ}{\cal{J}}
\newcommand{\cK}{\cal{K}} \newcommand{\cL}{\cal{L}}
\newcommand{\cM}{\cal{M}} \newcommand{\cN}{\cal{N}} 
\newcommand{\cO}{\cal{O}} \newcommand{\cP}{\cal{P}}
\newcommand{\cQ}{\cal{Q}} \newcommand{\cR}{\cal{R}}
\newcommand{\cS}{\cal{S}} \newcommand{\cT}{\cal{T}}
\newcommand{\cU}{\cal{U}} \newcommand{\cV}{\cal{V}}
\newcommand{\cW}{\cal{W}} \newcommand{\cX}{\cal{X}}
\newcommand{\cY}{\cal{Y}} \newcommand{\cZ}{\cal{Z}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Inverse Matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\bAi}{\bA^{-1}} \newcommand{\bBi}{\bB^{-1}}
\newcommand{\bCi}{\bC^{-1}} \newcommand{\bDi}{\bD^{-1}}  
\newcommand{\bEi}{\bE^{-1}} \newcommand{\bFi}{\bF^{-1}}
\newcommand{\bGi}{\bG^{-1}} \newcommand{\bHi}{\bH^{-1}} 
\newcommand{\bIi}{\bI^{-1}} \newcommand{\bJi}{\bJ^{-1}}
\newcommand{\bKi}{\bK^{-1}} \newcommand{\bLi}{\bL^{-1}} 
\newcommand{\bMi}{\bM^{-1}} \newcommand{\bNi}{\bN^{-1}}
\newcommand{\bOi}{\bO^{-1}} \newcommand{\bPin}{\bP^{-1}} 
\newcommand{\bQi}{\bQ^{-1}} \newcommand{\bRi}{\bR^{-1}}
\newcommand{\bSi}{\bS^{-1}} \newcommand{\bTi}{\bT^{-1}} 
\newcommand{\bUi}{\bU^{-1}} \newcommand{\bVi}{\bV^{-1}}
\newcommand{\bWi}{\bW^{-1}} \newcommand{\bXin}{\bX^{-1}} 
\newcommand{\bYi}{\bY^{-1}} \newcommand{\bZi}{\bZ^{-1}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Things I just added (subject to change)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\includefig}[2]{%
 \begin{figure}[!th]
   \begin{center}
     \includegraphics[width=#2]{#1}
   \end{center}
 \end{figure}
}

\newcommand{\twosubfig}[7]{
\begin{figure}[!htb]
   \begin{center}
       \subfigure[\textsf{#3}]{\includegraphics[width=#2]{#1}}
      \subfigure[\textsf{#6}]{\includegraphics[width=#5]{#4}}
       \caption{\textsf{#7}}
   \end{center}
\end{figure}}

\renewcommand{\figurename}{\textsc{Figure}}
\newcommand{\figref}[1]{Figure~\ref{#1}}
\renewcommand{\topfraction}{0.85}
\renewcommand{\textfraction}{0.1}

